/*! \file    
**********************************************************************************	
* Title:						Discretix SST API Source file						 					
*																			
* Filename:						sst_api.c															
*																			
* Project, Target, subsystem:	SST 6.0, Stubs, API
* 
* Created:						11.03.2007														
*
* Modified:						07.06.2007										
*
* \Author						Raviv levi														
*																			
* \Remarks						
*           Copyright (C) 2006 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

/*----------- External include files ----------------------------------------*/
#include "DX_VOS_Mem.h"
#include "dx_hw_defs.h"
#include "sst_host_op_code.h"
/*----------- Local include files -------------------------------------------*/
#include "sst_authentication.h"



/*---------------------------------------------------------------------------*/
/*               API FUNCTIONS                                               */
/*---------------------------------------------------------------------------*/
 /*Authentication and Authorization services*/


/*SST_AuthenticatorPasswordCreate*/
DxError_t SST_AuthenticatorPasswordCreate(SSTTxnId_t      aTransactionId,
                                          SSTSessionId_t  aSessionId,                              
                                          DxByte_t       *aPwd_ptr,
                                          DxUint32_t      aPwdsizeInBytes,
                                          DxUint32_t      aMaxNumOfTrials,
                                          SSTHandle_t     aInitialCtrlAuth,
                                          SSTHandle_t    *aAuthHandle_ptr,
                                          DxByte_t       *aWorkspace_ptr,
                                          DxUint32_t      aWorkspaceSizeInBytes)
{
    /* sizeof(SSTHandle_t) == 2 words */
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_AUTH_PASSWORD_CREATE, 10,
	   							 /* PARAMETERS: */
                                  aTransactionId,
                                  aSessionId,                              
                                  aPwd_ptr,
                                  aPwdsizeInBytes,
                                  aMaxNumOfTrials,
                                  aInitialCtrlAuth,
                                  aAuthHandle_ptr,
                                  aWorkspace_ptr,
                                  aWorkspaceSizeInBytes );
}



/*SST_AuthenticatorPubKeyRSACreate*/	
DxError_t SST_AuthenticatorPubKeyRSACreate(SSTTxnId_t   aTransactionId,
                                        DxByte_t    *aN_ptr,
                                        DxByte_t    *aE_ptr,
                                        DxUint32_t   aESize,
    /* todo doc*/                       SSTHandle_t *aAuthHandle_ptr,
                                        DxByte_t    *aWorkspace_ptr,
                                        DxUint32_t   aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_AUTH_PUB_KEY_RSA_CREATE, 7,
	   							 /* PARAMETERS: */
                                    aTransactionId,
                                    aN_ptr,
                                    aE_ptr,
                                    aESize,
                                    aAuthHandle_ptr,
                                    aWorkspace_ptr,
                                    aWorkspaceSizeInBytes );
}

/*SST_AuthenticatorPubKeyECCCreate*/	
DxError_t SST_AuthenticatorPubKeyECCCreate( SSTTxnId_t   aTransactionId,
										    DxByte_t    *aECCPubKey_ptr,
										    DxUint32_t   aECCPubKeySizeInBytes,
						                    SSTHandle_t *aAuthHandle_ptr,
											DxByte_t    *aWorkspace_ptr,
											DxUint32_t   aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_AUTH_PUB_KEY_ECC_CREATE, 6,
	   							 /* PARAMETERS: */
                                    aTransactionId,
                                    aECCPubKey_ptr,
                                    aECCPubKeySizeInBytes,
                                    aAuthHandle_ptr,
                                    aWorkspace_ptr,
                                    aWorkspaceSizeInBytes );
}


/*SST_AuthenticatorAESSharedSecretCreate*/	
DxError_t SST_AuthenticatorAESSharedSecretCreate(SSTTxnId_t   aTransactionId,
                                                 DxByte_t    *aAesKey_ptr,
                                                 SSTAESKeyType_t aKeyType,
                                                 SSTHandle_t *aAuthHandle_ptr,
                                                 DxByte_t    *aWorkspace_ptr,
                                                 DxUint32_t   aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_AUTH_AES_SHARED_SECRET_CREATE, 6,
	   							 /* PARAMETERS: */
                                 aTransactionId,
                                 aAesKey_ptr,
                                 aKeyType,
                                 aAuthHandle_ptr,
                                 aWorkspace_ptr,
                                 aWorkspaceSizeInBytes );
}

/* todo - check that auth' handles are auth handles */

/*SST_AuthenticatorDelete*/	
DxError_t SST_AuthenticatorDelete(SSTTxnId_t aTransactionId,SSTHandle_t aAuthHandle)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_AUTH_DELETE, 3,
	   							 /* PARAMETERS: */
                                 aTransactionId,
                                 aAuthHandle );
}



/*SST_SessionCreate*/	
DxError_t SST_SessionCreate(SSTSessionId_t *aSessionId_ptr)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_AUTH_SESSION_CREATE, 1,
	   							 /* PARAMETERS: */
                                 aSessionId_ptr );
}

/*SST_SessionDelete*/	
DxError_t SST_SessionDelete(SSTSessionId_t aSessionId)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_AUTH_SESSION_DELETE	, 1,
		/* PARAMETERS: */
		aSessionId );
}


/*SST_AuthenticatorChallengeGet*/	
DxError_t SST_AuthenticatorChallengeGet(DxByte_t          *aChallengeBuff_ptr,
                                        DxUint32_t         aChallengeBuffsizeInBytes,  
                                        SSTChallengeId_t  *aChallengeId_ptr)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_AUTH_CHALLENGE_GET, 3,
	   							 /* PARAMETERS: */
                                 aChallengeBuff_ptr,
                                 aChallengeBuffsizeInBytes,
                                 aChallengeId_ptr );
}


/*SST_AuthenticationOpen*/	
DxError_t SST_AuthenticationOpen(SSTSessionId_t    aSessionId,
                                 SSTHandle_t       aAuthHandle,
                                 DxByte_t         *aAuthBuff_ptr,
                                 DxUint32_t        aAuthBuffSizeInBytes,
                                 SSTChallengeId_t  aChallengeId,
                                 DxByte_t         *aWorkspace_ptr,
                                 DxUint32_t        aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_AUTH_OPEN, 8,
	   							 /* PARAMETERS: */
                                 aSessionId,
                                 aAuthHandle,
                                 aAuthBuff_ptr,
                                 aAuthBuffSizeInBytes,
                                 aChallengeId,
                                 aWorkspace_ptr,
                                 aWorkspaceSizeInBytes );
}


/*SST_AuthenticationClose*/
DxError_t SST_AuthenticationClose(SSTSessionId_t aSessionId,SSTHandle_t aAuthHandle)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_AUTH_CLOSE, 3,
	   							 /* PARAMETERS: */
                                 aSessionId,
                                 aAuthHandle );
}


/*SST_AuthenticatorPasswordResetAndChange*/	
DxError_t SST_AuthenticatorPasswordResetAndChange(SSTTxnId_t      aTransactionId,
                                                  SSTSessionId_t  aSessionId,
                                                  SSTHandle_t     aAuthHandle,  
                                                  DxUint32_t      aNewPwdsizeInBytes,                    
                                                  DxByte_t       *aNewPwd_ptr,
                                                  DxUint32_t      aNewMaxRetry,
                                                  DxByte_t       *aWorkspace_ptr,
                                                  DxUint32_t      aWorkspaceSizeInBytes)                                                  
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_AUTH_PASSWORD_RESET_AND_CHANGE, 9,
	   							 /* PARAMETERS: */
                                  aTransactionId,
                                  aSessionId,
                                  aAuthHandle,  
                                  aNewPwdsizeInBytes,                    
                                  aNewPwd_ptr,
                                  aNewMaxRetry,
                                  aWorkspace_ptr,
                                  aWorkspaceSizeInBytes );
}


/*SST_AuthenticatorBind*/	
DxError_t SST_AuthenticatorBind(SSTTxnId_t        aTransactionId,  
                                SSTSessionId_t    aSessionId, 
                                SSTHandle_t       aObjHandle,              
                                SSTHandle_t       aAuthToBind,             
                                SSTPermissions_t  aPermission,
                                DxByte_t         *aWorkspace_ptr,
                                DxUint32_t        aWorkspaceSizeInBytes)                                
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_AUTH_BIND, 9,
	   							 /* PARAMETERS: */
                                aTransactionId,  
                                aSessionId, 
                                aObjHandle,              
                                aAuthToBind,             
                                aPermission,
                                aWorkspace_ptr,
                                aWorkspaceSizeInBytes );
}



/*SST_AuthenticatorUnbind*/
DxError_t SST_AuthenticatorUnbind(SSTTxnId_t        aTransactionId,   
                                  SSTSessionId_t    aSessionId,
                                  SSTHandle_t       aObjHandle,              
                                  SSTHandle_t		aAuthToUnbind,
                                  SSTPermissions_t  aPermission,
                                  DxByte_t         *aWorkspace_ptr,
                                  DxUint32_t        aWorkspaceSizeInBytes)                                  
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_AUTH_UNBIND, 9,
	   							 /* PARAMETERS: */
                                  aTransactionId,   
                                  aSessionId,
                                  aObjHandle,              
                                  aAuthToUnbind,
                                  aPermission,
                                  aWorkspace_ptr,
                                  aWorkspaceSizeInBytes );
}


/*SST_AuthenticatorAppIDCreate*/
DxError_t SST_AuthenticatorAppIDCreate(SSTTxnId_t      aTransactionId,
                                       SSTSessionId_t  aSessionId,                              
                                       DxByte_t       *aAppID_ptr,
                                       DxUint32_t      aAppIDsizeInBytes,
                                       SSTHandle_t    *aAuthHandle_ptr,
                                       DxByte_t       *aWorkspace_ptr,
                                       DxUint32_t      aWorkspaceSizeInBytes)
{
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_AUTH_APP_ID_CREATE, 8,
	   							 /* PARAMETERS: */
                                  aTransactionId,
                                  aSessionId,                              
                                  aAppID_ptr,
                                  aAppIDsizeInBytes,
                                  aAuthHandle_ptr,
                                  aWorkspace_ptr,
                                  aWorkspaceSizeInBytes );
}
